% Akesson_method.m
% Chris Gowen
% April, 2012
% 
% This script is provided to accompany the chapter "Linking RNA 
% measurements and proteomics with genome-scale models" in Methods in
% Molecular Biology: Systems Metabolic Engineering, ed. Hal Alper
%
% It is provided for educational purposes only, without any warranty.

% Load the iMM904 yeast model (Mo M. et al, BMC Systems Biology, 2009)
load iMM904.mat

% Set objective value to maximize growth rate:
model = changeObjective(model,{'biomass_SC5_notrace'},1);

% Set glucose uptake to reflect observation. O2 is saturated, so don't
% limit O2 uptake.
model_ss_wt = changeRxnBounds(model,{'EX_glc(e)' 'EX_o2(e)'},[-0.9376 -1000],'l');
model_5h_wt = changeRxnBounds(model,{'EX_glc(e)' 'EX_o2(e)'},[-3.2752 -1000],'l');

% Find the low genes that are in the model:
low_transcr_names_ss = transcr_IDs(low_transcr{3});
low_genes_ss = []; low_genes_5h = [];
for i=1:length(low_transcr_names_ss)
    gene = low_transcr_names_ss(i); 
    low_genes_ss = [low_genes_ss strmatch(gene, model.genes, 'exact')];
end
low_transcr_names_5h = transcr_IDs(low_transcr{14});
for i=1:length(low_transcr_names_5h)
    gene = low_transcr_names_5h(i); 
    low_genes_5h = [low_genes_5h strmatch(gene, model.genes, 'exact')];
end

% Block flux on reactions which are coded by low-expression genes:
[model_ss_reg,hasEffect_ss,lowRxns_ss,deletedGenes_ss] = ...
    deleteModelGenes(model_ss_wt,model.genes(low_genes_ss),0.00001);
[model_5h_reg,hasEffect_5h,lowRxns_5h,deletedGenes_5h] = ...
    deleteModelGenes(model_5h_wt,model.genes(low_genes_5h),0.00001);

%%% At this point, trimmed models have been created for both time points
%%% based on gene expression data. These models can be analyzed using a
%%% wide range of constraints-based modeling methods, including flux
%%% balance analysis (FBA), flux variability analysis (FVA), sampling, etc.

% Perform FBA as normal.
fba_ss_wt = optimizeCbModel(model_ss_wt);
fba_ss_reg = optimizeCbModel(model_ss_reg);
fba_5h_wt = optimizeCbModel(model_5h_wt);
fba_5h_reg = optimizeCbModel(model_5h_reg);

% Print flux vectors to Excel:
printFluxVector(model,[fba_ss_wt.x fba_ss_reg.x fba_5h_wt.x fba_5h_reg.x],...
    0,0,-1,'yeast_glc_fluxes.txt',[],1);